
`Object data
type Lighting_ObjectData
   InUse as integer
   Object as integer
   Alpha as integer
   Dynamic as integer
   Dist as float
   Visible as integer
   InScreen as integer
   CullDist as float
   Position as Vec3Float
   Rotation as Vec3Float
   ShadowUpdatePos as Vec3Integer
   ShadowUpdateAng as Vec3Integer
   DynamicUpdate as integer
   DynamicUpdateTime as float
   BoundPosition as Vec3Float
   BoundSize as Vec4Float
   Shadows as integer
   ShadowUpdate as integer
   Active as integer
   ActiveStatic as integer
   ActiveAlpha as integer
   ActiveShadowNull as integer
   ActiveShadow1Null as integer
   ActiveShadow2Null as integer
   ActiveShadow3Null as integer
   ActiveShadow4Null as integer
   ActiveShadowCull as integer
endtype

`--------------
` Add Object
`--------------
function AddObject(iObject as integer)
   tObject=-1
   if GetObjectExists(iObject)=1
      for o=Lighting_ObjectsFreeUp to Lighting_ObjectsCount
         if Lighting_Objects[o].InUse=0 and Lighting_Objects[o].Active=0 
            tObject=o
            exit
         endif
      next o
      if tObject=-1
         inc Lighting_ObjectsCount
         Lighting_Objects.length=Lighting_Objects.length+1
         Lighting_ObjectsShadowUpdate.length=Lighting_ObjectsShadowUpdate.length+1
         tObject=Lighting_ObjectsCount
      endif
      Lighting_ObjectsFreeUp=tObject
      Lighting_Objects[tObject].InUse=1
      Lighting_Objects[tObject].Visible=1
      Lighting_Objects[tObject].Object=iObject
      Lighting_Objects[tObject].Position.x=-999999999
      Lighting_Objects[tObject].ShadowUpdatePos.x=-999999999
      Lighting_Objects[tObject].CullDist=2500
      Lighting_Objects[tObject].Shadows=0
      Lighting_Objects[tObject].Dynamic=0
      Lighting_Objects[tObject].Alpha=0
      ObjectUpdate(tObject)
      SetObjectImage(iObject,Lighting_Image[1],4)
      SetObjectImage(iObject,Lighting_Image[3],5)
      SetObjectImage(iObject,Lighting_Image[4],6)
      SetObjectImage(iObject,Lighting_Image[5],7)
      SetObjectVisible(Lighting_Objects[tObject].Object,0)
   endif
endfunction tObject

`--------------
` Remove Object
`--------------
function RemoveObject(iObject as integer)
   if Lighting_Objects[iObject].InUse=1
      if Lighting_ObjectsFreeUp>iObject then Lighting_ObjectsFreeUp=iObject
      RemoveObjectActive(iObject)
      RemoveObjectActiveShadow(iObject)
      Lighting_Objects[iObject].InUse=0
      Lighting_Objects[iObject].ShadowUpdate=0
      SetObjectVisible(Lighting_Objects[iObject].Object,1)
   endif
endfunction

`--------------
` Set Object Visible
`--------------
function ObjectSetVisible(iObject as integer,ivisible as integer)
   if Lighting_Objects[iObject].InUse=1
      if Lighting_Objects[iObject].visible<>ivisible 
         Lighting_Objects[iObject].visible=ivisible
         if Lighting_Objects[iObject].visible=0 then SetObjectVisible(Lighting_Objects[iObject].Object,0)
      endif
   endif
endfunction

`--------------
` Set Object Cull Dist
`--------------
function ObjectSetCull(iObject as integer,iCullDist as float)
   if Lighting_Objects[iObject].InUse=1 then Lighting_Objects[iObject].CullDist=iCullDist
endfunction

`--------------
` Set Object Dynamic
`--------------
function ObjectSetDynamic(iObject as integer,iDynamic as integer)
   if Lighting_Objects[iObject].InUse=1
      if Lighting_Objects[iObject].Dynamic<>iDynamic
         Lighting_Objects[iObject].Dynamic=iDynamic
         RemoveObjectActive(iObject)
      endif
   endif
endfunction

`--------------
` Set Object Dynamic Update
`--------------
function ObjectSetDynamicUpdate(iObject as integer,iUpdateTime as integer)
   if Lighting_Objects[iObject].InUse=1 
      if Lighting_Objects[iObject].DynamicUpdate<>iUpdateTime then Lighting_Objects[iObject].DynamicUpdate=iUpdateTime
   endif
endfunction

`--------------
` Set Object Alpha
`--------------
function ObjectSetAlpha(iObject as integer,iAlpha as integer)
   if Lighting_Objects[iObject].InUse=1
      if Lighting_Objects[iObject].Alpha<>iAlpha
         Lighting_Objects[iObject].Alpha=iAlpha
         RemoveObjectActive(iObject)
         RemoveObjectActiveShadow(iObject)
         if Lighting_Objects[iObject].Alpha=0
            SetObjectImage(iObject,Lighting_Image[4],6)
         else
            SetObjectImage(iObject,Lighting_ShadowDirectionalImage[3],6)
         endif
      endif
   endif
endfunction

`--------------
` Set Object Shadows
`--------------
function ObjectSetShadow(iObject as integer,iShadows as integer)
   if Lighting_Objects[iObject].InUse=1 
      if Lighting_Objects[iObject].Shadows<>iShadows
         Lighting_Objects[iObject].Shadows=iShadows
         RemoveObjectActiveShadow(iObject)
      endif
   endif
endfunction

`--------------
` Update Object
`--------------
function ObjectUpdate(iObject as integer)
   tPosX#=GetObjectX(Lighting_Objects[iObject].Object)
   tPosY#=GetObjectY(Lighting_Objects[iObject].Object)
   tPosZ#=GetObjectZ(Lighting_Objects[iObject].Object)
   tAngX#=GetObjectAngleX(Lighting_Objects[iObject].Object)
   tAngY#=GetObjectAngleY(Lighting_Objects[iObject].Object)
   tAngZ#=GetObjectAngleZ(Lighting_Objects[iObject].Object)
   if Lighting_Objects[iObject].Position.x<>tPosX# or Lighting_Objects[iObject].Position.y<>tPosY# or Lighting_Objects[iObject].Position.Z<>tPosZ# or Lighting_Objects[iObject].Rotation.x<>tAngX# or Lighting_Objects[iObject].Rotation.y<>tAngY# or Lighting_Objects[iObject].Rotation.z<>tAngZ#
      AxisAlignedBoundingBox(Lighting_Objects[iObject].Object)
      Lighting_Objects[iObject].Position.x=tPosX#
      Lighting_Objects[iObject].Position.y=tPosY#
      Lighting_Objects[iObject].Position.z=tPosZ#
      Lighting_Objects[iObject].Rotation.x=tAngX#
      Lighting_Objects[iObject].Rotation.y=tAngY#
      Lighting_Objects[iObject].Rotation.z=tAngZ#
      Lighting_Objects[iObject].BoundPosition.x=MinMaxPos.x
      Lighting_Objects[iObject].BoundPosition.y=MinMaxPos.y
      Lighting_Objects[iObject].BoundPosition.z=MinMaxPos.z
      Lighting_Objects[iObject].BoundSize.x=MinMaxSize.x
      Lighting_Objects[iObject].BoundSize.y=MinMaxSize.y
      Lighting_Objects[iObject].BoundSize.z=MinMaxSize.z
      Lighting_Objects[iObject].BoundSize.w=MinMaxSize.x*1.45
      if MinMaxSize.y*1.45>Lighting_Objects[iObject].BoundSize.w then Lighting_Objects[iObject].BoundSize.w=MinMaxSize.y*1.45
      if MinMaxSize.z*1.45>Lighting_Objects[iObject].BoundSize.w then Lighting_Objects[iObject].BoundSize.w=MinMaxSize.z*1.45
      if Lighting_Objects[iObject].Shadows=1 and Lighting_Objects[iObject].Alpha=0
         if Lighting_Objects[iObject].ShadowUpdate=0
            Lighting_Objects[iObject].ShadowUpdate=1
            inc Lighting_ObjectsShadowUpdateCount
            Lighting_ObjectsShadowUpdate[Lighting_ObjectsShadowUpdateCount]=iObject
          endif
      endif
   endif
endfunction

`--------------
` Objects Update
`--------------
function ObjectsUpdate(iTimer as float)

   `Active objects
      if Lighting_ObjectsCount>-1
         for o=0 to 64
            tObject=Lighting_ObjectsActiveFind
            if Lighting_Objects[tObject].InUse=1 and Lighting_Objects[tObject].Visible=1 
               ApplyObjectActive(tObject) 
            else
               RemoveObjectActive(tObject)
               RemoveObjectActiveShadow(tObject)
            endif
            inc Lighting_ObjectsActiveFind
            if Lighting_ObjectsActiveFind>Lighting_ObjectsCount 
               Lighting_ObjectsActiveFind=0
               exit
            endif
         next o
      endif

   `Dynamic Object Update
      for o=0 to Lighting_ObjectsActiveCount
         tObject=Lighting_ObjectsActive[o]-1
         if Lighting_Objects[tObject].DynamicUpdate>0
            dec Lighting_Objects[tObject].DynamicUpdateTime,iTimer*100
            if Lighting_Objects[tObject].DynamicUpdateTime<0
               Lighting_Objects[tObject].DynamicUpdateTime=Lighting_Objects[tObject].DynamicUpdate
               Lighting_Objects[tObject].Position.x=Lighting_Objects[tObject].Position.x+1
               Lighting_Objects[tObject].ShadowUpdatePos.x=Lighting_Objects[tObject].ShadowUpdatePos.x+1
            endif
         endif
         ObjectUpdate(tObject)
      next o

   `Shadows Update
      if Lighting_ObjectsShadowUpdateCount>-1 
         for o=0 to Lighting_ObjectsShadowUpdateCount
            tObject=Lighting_ObjectsShadowUpdate[o]
            if Lighting_Objects[tObject].ShadowUpdate=1
               Lighting_Objects[tObject].ShadowUpdate=0
               if Lighting_Objects[tObject].ShadowUpdatePos.x<>round(Lighting_Objects[tObject].Position.x*2) or Lighting_Objects[tObject].ShadowUpdatePos.y<>round(Lighting_Objects[tObject].Position.y*2) or Lighting_Objects[tObject].ShadowUpdatePos.z<>round(Lighting_Objects[tObject].Position.z*2) or Lighting_Objects[tObject].ShadowUpdateAng.x<>round(Lighting_Objects[tObject].Rotation.x) or Lighting_Objects[tObject].ShadowUpdateAng.y<>round(Lighting_Objects[tObject].Rotation.y) or Lighting_Objects[tObject].ShadowUpdateAng.z<>round(Lighting_Objects[tObject].Rotation.z)
                  Vector4Float[1].x=Lighting_Objects[tObject].ShadowUpdatePos.x/2:Vector4Float[1].y=Lighting_Objects[tObject].ShadowUpdatePos.y/2:Vector4Float[1].z=Lighting_Objects[tObject].ShadowUpdatePos.z/2
                  Vector4Float[2].x=Lighting_Objects[tObject].BoundPosition.x:Vector4Float[2].y=Lighting_Objects[tObject].BoundPosition.y:Vector4Float[2].z=Lighting_Objects[tObject].BoundPosition.z
                  Lighting_Objects[tObject].ShadowUpdatePos.x=round(Lighting_Objects[tObject].Position.x*2)
                  Lighting_Objects[tObject].ShadowUpdatePos.y=round(Lighting_Objects[tObject].Position.y*2)
                  Lighting_Objects[tObject].ShadowUpdatePos.z=round(Lighting_Objects[tObject].Position.z*2)
                  Lighting_Objects[tObject].ShadowUpdateAng.x=round(Lighting_Objects[tObject].Rotation.x)
                  Lighting_Objects[tObject].ShadowUpdateAng.y=round(Lighting_Objects[tObject].Rotation.y)
                  Lighting_Objects[tObject].ShadowUpdateAng.z=round(Lighting_Objects[tObject].Rotation.z)
                  for x=1 to Lighting_MaxShadows
                     if Lighting_ShadowPointLight[x]>0
                        tLight=Lighting_ShadowPointLight[x]-1
                        for c=1 to 2
                           SetVector3(Vector3AGK.x,Lighting_Lights[tLight].Position.x-Vector4Float[c].x,Lighting_Lights[tLight].Position.y-Vector4Float[c].y,Lighting_Lights[tLight].Position.z-Vector4Float[c].z)
                           if GetVector3Length(Vector3AGK.x)<(Lighting_Objects[tObject].BoundSize.w*0.5)+Lighting_Lights[tLight].Range
                              Vector4Float[4].x=Lighting_Objects[tObject].BoundSize.x+(Lighting_Lights[tLight].Range*2)
                              Vector4Float[4].y=Lighting_Objects[tObject].BoundSize.y+(Lighting_Lights[tLight].Range*2)
                              Vector4Float[4].z=Lighting_Objects[tObject].BoundSize.z+(Lighting_Lights[tLight].Range*2)
                              Vector4Float[5].x=Vector4Float[c].x-Lighting_Lights[tLight].Position.x
                              Vector4Float[5].y=Vector4Float[c].y-Lighting_Lights[tLight].Position.y
                              Vector4Float[5].z=Vector4Float[c].z-Lighting_Lights[tLight].Position.z
                              if Vector4Float[c].x+(Lighting_Objects[tObject].BoundSize.x)>Lighting_Lights[tLight].Position.x
                                 if Lighting_Lights[tLight].Position.y<Vector4Float[c].y+((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)+Vector4Float[5].x) and Lighting_Lights[tLight].Position.y>Vector4Float[c].y-((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)+Vector4Float[5].x)
                                    if Lighting_Lights[tLight].Position.z<Vector4Float[c].z+((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)+Vector4Float[5].x) and Lighting_Lights[tLight].Position.z>Vector4Float[c].z-((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)+Vector4Float[5].x) then Lighting_ShadowPoint[x].Face1Update=1
                                 endif
                              endif
                              if Vector4Float[c].x-(Lighting_Objects[tObject].BoundSize.x)<Lighting_Lights[tLight].Position.x
                                 if Lighting_Lights[tLight].Position.y<Vector4Float[c].y+((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)-Vector4Float[5].x) and Lighting_Lights[tLight].Position.y>Vector4Float[c].y-((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)-Vector4Float[5].x)
                                    if Lighting_Lights[tLight].Position.z<Vector4Float[c].z+((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)-Vector4Float[5].x) and Lighting_Lights[tLight].Position.z>Vector4Float[c].z-((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.x/1.5)-Vector4Float[5].x) then Lighting_ShadowPoint[x].Face2Update=1
                                 endif
                              endif
                              if Vector4Float[c].y+(Lighting_Objects[tObject].BoundSize.y)>Lighting_Lights[tLight].Position.y
                                 if Lighting_Lights[tLight].Position.x<Vector4Float[c].x+((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)+Vector4Float[5].y) and Lighting_Lights[tLight].Position.x>Vector4Float[c].x-((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)+Vector4Float[5].y)
                                    if Lighting_Lights[tLight].Position.z<Vector4Float[c].z+((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)+Vector4Float[5].y) and Lighting_Lights[tLight].Position.z>Vector4Float[c].z-((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)+Vector4Float[5].y) then Lighting_ShadowPoint[x].Face3Update=1
                                 endif
                              endif
                              if Vector4Float[c].y-(Lighting_Objects[tObject].BoundSize.y)<Lighting_Lights[tLight].Position.y
                                 if Lighting_Lights[tLight].Position.x<Vector4Float[c].x+((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)-Vector4Float[5].y) and Lighting_Lights[tLight].Position.x>Vector4Float[c].x-((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)-Vector4Float[5].y)
                                    if Lighting_Lights[tLight].Position.z<Vector4Float[c].z+((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)-Vector4Float[5].y) and Lighting_Lights[tLight].Position.z>Vector4Float[c].z-((Lighting_Objects[tObject].BoundSize.z/1.5)+(Lighting_Objects[tObject].BoundSize.y/1.5)-Vector4Float[5].y) then Lighting_ShadowPoint[x].Face4Update=1
                                 endif
                              endif
                              if Vector4Float[c].z+(Lighting_Objects[tObject].BoundSize.z)>Lighting_Lights[tLight].Position.z
                                 if Lighting_Lights[tLight].Position.x<Vector4Float[c].x+((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)+Vector4Float[5].z) and Lighting_Lights[tLight].Position.x>Vector4Float[c].x-((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)+Vector4Float[5].z)
                                    if Lighting_Lights[tLight].Position.y<Vector4Float[c].y+((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)+Vector4Float[5].z) and Lighting_Lights[tLight].Position.y>Vector4Float[c].y-((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)+Vector4Float[5].z) then Lighting_ShadowPoint[x].Face5Update=1
                                 endif
                              endif
                              if Vector4Float[c].z-(Lighting_Objects[tObject].BoundSize.z)<Lighting_Lights[tLight].Position.z
                                 if Lighting_Lights[tLight].Position.x<Vector4Float[c].x+((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)-Vector4Float[5].z) and Lighting_Lights[tLight].Position.x>Vector4Float[c].x-((Lighting_Objects[tObject].BoundSize.x/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)-Vector4Float[5].z)
                                    if Lighting_Lights[tLight].Position.y<Vector4Float[c].y+((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)-Vector4Float[5].z) and Lighting_Lights[tLight].Position.y>Vector4Float[c].y-((Lighting_Objects[tObject].BoundSize.y/1.5)+(Lighting_Objects[tObject].BoundSize.z/1.5)-Vector4Float[5].z) then Lighting_ShadowPoint[x].Face6Update=1
                                 endif
                              endif
                           endif
                        next c
                     endif
                     if Lighting_ShadowSpotLight[x]>0
                        tLight=Lighting_ShadowSpotLight[x]-1
                        for c=1 to 2
                           SetVector3(Vector3AGK.x,Lighting_Lights[tLight].Position.x-Vector4Float[c].x,Lighting_Lights[tLight].Position.y-Vector4Float[c].y,Lighting_Lights[tLight].Position.z-Vector4Float[c].z)
                           if GetVector3Length(Vector3AGK.x)<(Lighting_Objects[tObject].BoundSize.w*0.5)+Lighting_Lights[tLight].Range
                              if GetSphereInFrustum(x,Vector4Float[c].x,Vector4Float[c].y,Vector4Float[c].z,Lighting_Objects[tObject].BoundSize.w)=1
                                 Lighting_ShadowSpot[x].Face1Update=1
                              endif
                           endif
                        next c
                     endif
                  next x
               endif
            endif
         next o
         Lighting_ObjectsShadowUpdateCount=-1
      endif
 
endfunction

`--------------
` Apply Active Object
`--------------
function ApplyObjectActive(iObject as integer)
   SetVector3(Vector3AGK.x,Lighting_CameraPosition.x-GetObjectX(Lighting_Objects[iObject].Object),Lighting_CameraPosition.y-GetObjectY(Lighting_Objects[iObject].Object),Lighting_CameraPosition.z-GetObjectZ(Lighting_Objects[iObject].Object))
   Lighting_Objects[iObject].Dist=GetVector3Length(Vector3AGK.x)
   if Lighting_Objects[iObject].Dist<Lighting_Objects[iObject].CullDist*(1+(Lighting_Objects[iObject].BoundSize.w*0.01)) and Lighting_Objects[iObject].Visible=1
      if Lighting_Objects[iObject].Dynamic=1
         if Lighting_Objects[iObject].Active=0
            if Lighting_ObjectsActiveCount=>Lighting_ObjectsActive.length then Lighting_ObjectsActive.length=Lighting_ObjectsActive.length+1
            inc Lighting_ObjectsActiveCount : Lighting_ObjectsActive[Lighting_ObjectsActiveCount]=iObject+1
            Lighting_Objects[iObject].Active=Lighting_ObjectsActiveCount+1
            if Lighting_Objects[iObject].Alpha=0 then setObjectVisible(Lighting_Objects[iObject].Object,1)
         endif
      else
         if Lighting_Objects[iObject].ActiveStatic=0
            if Lighting_ObjectsActiveStaticCount=>Lighting_ObjectsActiveStatic.length then Lighting_ObjectsActiveStatic.length=Lighting_ObjectsActiveStatic.length+1
            inc Lighting_ObjectsActiveStaticCount : Lighting_ObjectsActiveStatic[Lighting_ObjectsActiveStaticCount]=iObject+1
            Lighting_Objects[iObject].ActiveStatic=Lighting_ObjectsActiveStaticCount+1
            if Lighting_Objects[iObject].Alpha=0 then SetObjectVisible(Lighting_Objects[iObject].Object,1)
         endif
      endif
      if Lighting_Objects[iObject].Alpha=1
         if Lighting_Objects[iObject].ActiveAlpha=0
            if Lighting_ObjectsActiveAlphaCount=>Lighting_ObjectsActiveAlpha.length then Lighting_ObjectsActiveAlpha.length=Lighting_ObjectsActiveAlpha.length+1
            inc Lighting_ObjectsActiveAlphaCount : Lighting_ObjectsActiveAlpha[Lighting_ObjectsActiveAlphaCount]=iObject+1
            Lighting_Objects[iObject].ActiveAlpha=Lighting_ObjectsActiveAlphaCount+1
         endif
      endif
      if Lighting_Objects[iObject].Alpha=0
         if Lighting_Objects[iObject].Shadows=0 
            if Lighting_Objects[iObject].ActiveShadowNull=0
               if Lighting_ObjectsActiveShadowNullCount=>Lighting_ObjectsActiveShadowNull.length then Lighting_ObjectsActiveShadowNull.length=Lighting_ObjectsActiveShadowNull.length+1
               inc Lighting_ObjectsActiveShadowNullCount : Lighting_ObjectsActiveShadowNull[Lighting_ObjectsActiveShadowNullCount]=iObject+1
               Lighting_Objects[iObject].ActiveShadowNull=Lighting_ObjectsActiveShadowNullCount+1
            endif
         else
            if Lighting_Objects[iObject].BoundSize.w/Lighting_ShadowRange[1]<0.025
               if Lighting_Objects[iObject].ActiveShadow1Null=0
                  if Lighting_ObjectsActiveShadow1NullCount=>Lighting_ObjectsActiveShadow1Null.length then Lighting_ObjectsActiveShadow1Null.length=Lighting_ObjectsActiveShadow1Null.length+1
                  inc Lighting_ObjectsActiveShadow1NullCount : Lighting_ObjectsActiveShadow1Null[Lighting_ObjectsActiveShadow1NullCount]=iObject+1
                  Lighting_Objects[iObject].ActiveShadow1Null=Lighting_ObjectsActiveShadow1NullCount+1
               endif
            endif
            if Lighting_Objects[iObject].BoundSize.w/Lighting_ShadowRange[2]<0.025
               if Lighting_Objects[iObject].ActiveShadow2Null=0
                  if Lighting_ObjectsActiveShadow2NullCount=>Lighting_ObjectsActiveShadow2Null.length then Lighting_ObjectsActiveShadow2Null.length=Lighting_ObjectsActiveShadow2Null.length+1
                  inc Lighting_ObjectsActiveShadow2NullCount : Lighting_ObjectsActiveShadow2Null[Lighting_ObjectsActiveShadow2NullCount]=iObject+1
                  Lighting_Objects[iObject].ActiveShadow2Null=Lighting_ObjectsActiveShadow2NullCount+1
               endif
            endif
            if Lighting_Objects[iObject].BoundSize.w/Lighting_ShadowRange[3]<0.025
               if Lighting_Objects[iObject].ActiveShadow3Null=0
                  if Lighting_ObjectsActiveShadow3NullCount=>Lighting_ObjectsActiveShadow3Null.length then Lighting_ObjectsActiveShadow3Null.length=Lighting_ObjectsActiveShadow3Null.length+1
                  inc Lighting_ObjectsActiveShadow3NullCount : Lighting_ObjectsActiveShadow3Null[Lighting_ObjectsActiveShadow3NullCount]=iObject+1
                  Lighting_Objects[iObject].ActiveShadow3Null=Lighting_ObjectsActiveShadow3NullCount+1
               endif
            endif
            if Lighting_Objects[iObject].BoundSize.w/Lighting_ShadowRange[4]<0.025
               if Lighting_Objects[iObject].ActiveShadow4Null=0
                  if Lighting_ObjectsActiveShadow4NullCount=>Lighting_ObjectsActiveShadow4Null.length then Lighting_ObjectsActiveShadow4Null.length=Lighting_ObjectsActiveShadow4Null.length+1
                  inc Lighting_ObjectsActiveShadow4NullCount : Lighting_ObjectsActiveShadow4Null[Lighting_ObjectsActiveShadow4NullCount]=iObject+1
                  Lighting_Objects[iObject].ActiveShadow4Null=Lighting_ObjectsActiveShadow4NullCount+1
               endif
            endif
            if Lighting_Objects[iObject].Shadows=2
               if Lighting_Objects[iObject].ActiveShadowCull=0
                  if Lighting_ObjectsActiveShadowCullCount=>Lighting_ObjectsActiveShadowCull.length then Lighting_ObjectsActiveShadowCull.length=Lighting_ObjectsActiveShadowCull.length+1
                  inc Lighting_ObjectsActiveShadowCullCount : Lighting_ObjectsActiveShadowCull[Lighting_ObjectsActiveShadowCullCount]=iObject+1
                  Lighting_Objects[iObject].ActiveShadowCull=Lighting_ObjectsActiveShadowCullCount+1
               endif
            endif
         endif
      endif
   else
      RemoveObjectActive(iObject)
      RemoveObjectActiveShadow(iObject)
   endif
endfunction

`--------------
` Remove Active Object
`--------------
function RemoveObjectActive(iObject as integer)
   if Lighting_Objects[iObject].Active>0
      tIndex=Lighting_Objects[iObject].Active-1
      if tIndex<Lighting_ObjectsActiveCount
         tActive=Lighting_ObjectsActive[Lighting_ObjectsActiveCount]-1
         Lighting_Objects[tActive].Active=tIndex+1
         Lighting_ObjectsActive[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveCount : Lighting_Objects[iObject].Active=0
   endif
   if Lighting_Objects[iObject].ActiveStatic>0
      tIndex=Lighting_Objects[iObject].ActiveStatic-1
      if tIndex<Lighting_ObjectsActiveStaticCount
         tActive=Lighting_ObjectsActiveStatic[Lighting_ObjectsActiveStaticCount]-1
         Lighting_Objects[tActive].ActiveStatic=tIndex+1
         Lighting_ObjectsActiveStatic[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveStaticCount : Lighting_Objects[iObject].ActiveStatic=0
   endif
   RemoveObjectActiveShadow(iObject)
   Lighting_Objects[iObject].InScreen=0
   SetObjectVisible(Lighting_Objects[iObject].Object,0)
endfunction
function RemoveObjectActiveShadow(iObject as integer)
   if Lighting_Objects[iObject].ActiveAlpha>0
      tIndex=Lighting_Objects[iObject].ActiveAlpha-1
      if tIndex<Lighting_ObjectsActiveAlphaCount
         tActive=Lighting_ObjectsActiveAlpha[Lighting_ObjectsActiveAlphaCount]-1
         Lighting_Objects[tActive].ActiveAlpha=tIndex+1
         Lighting_ObjectsActiveAlpha[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveAlphaCount : Lighting_Objects[iObject].ActiveAlpha=0
   endif
   if Lighting_Objects[iObject].ActiveShadowNull>0
      tIndex=Lighting_Objects[iObject].ActiveShadowNull-1
      if tIndex<Lighting_ObjectsActiveShadowNullCount
         tActive=Lighting_ObjectsActiveShadowNull[Lighting_ObjectsActiveShadowNullCount]-1
         Lighting_Objects[tActive].ActiveShadowNull=tIndex+1
         Lighting_ObjectsActiveShadowNull[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadowNullCount : Lighting_Objects[iObject].ActiveShadowNull=0
   endif
   if Lighting_Objects[iObject].ActiveShadow1Null>0
      tIndex=Lighting_Objects[iObject].ActiveShadow1Null-1
      if tIndex<Lighting_ObjectsActiveShadow1NullCount
         tActive=Lighting_ObjectsActiveShadow1Null[Lighting_ObjectsActiveShadow1NullCount]-1
         Lighting_Objects[tActive].ActiveShadow1Null=tIndex+1
         Lighting_ObjectsActiveShadow1Null[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadow1NullCount : Lighting_Objects[iObject].ActiveShadow1Null=0
   endif
   if Lighting_Objects[iObject].ActiveShadow2Null>0
      tIndex=Lighting_Objects[iObject].ActiveShadow2Null-1
      if tIndex<Lighting_ObjectsActiveShadow2NullCount
         tActive=Lighting_ObjectsActiveShadow2Null[Lighting_ObjectsActiveShadow2NullCount]-1
         Lighting_Objects[tActive].ActiveShadow2Null=tIndex+1
         Lighting_ObjectsActiveShadow2Null[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadow2NullCount : Lighting_Objects[iObject].ActiveShadow2Null=0
   endif
   if Lighting_Objects[iObject].ActiveShadow3Null>0
      tIndex=Lighting_Objects[iObject].ActiveShadow3Null-1
      if tIndex<Lighting_ObjectsActiveShadow3NullCount
         tActive=Lighting_ObjectsActiveShadow3Null[Lighting_ObjectsActiveShadow3NullCount]-1
         Lighting_Objects[tActive].ActiveShadow3Null=tIndex+1
         Lighting_ObjectsActiveShadow3Null[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadow3NullCount : Lighting_Objects[iObject].ActiveShadow3Null=0
   endif
   if Lighting_Objects[iObject].ActiveShadow4Null>0
      tIndex=Lighting_Objects[iObject].ActiveShadow4Null-1
      if tIndex<Lighting_ObjectsActiveShadow4NullCount
         tActive=Lighting_ObjectsActiveShadow4Null[Lighting_ObjectsActiveShadow4NullCount]-1
         Lighting_Objects[tActive].ActiveShadow4Null=tIndex+1
         Lighting_ObjectsActiveShadow4Null[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadow4NullCount : Lighting_Objects[iObject].ActiveShadow4Null=0
   endif
   if Lighting_Objects[iObject].ActiveShadowCull>0
      tIndex=Lighting_Objects[iObject].ActiveShadowCull-1
      if tIndex<Lighting_ObjectsActiveShadowCullCount
         tActive=Lighting_ObjectsActiveShadowCull[Lighting_ObjectsActiveShadowCullCount]-1
         Lighting_Objects[tActive].ActiveShadowCull=tIndex+1
         Lighting_ObjectsActiveShadowCull[tIndex]=tActive+1
      endif
      dec Lighting_ObjectsActiveShadowCullCount : Lighting_Objects[iObject].ActiveShadowCull=0
   endif
endfunction

`--------------
` Load Extra Tree Data (".dat" file is created when exporteing a ".x" file from Treeit)
`--------------
type VertexColorsData
  Red as integer[]
  Green as integer[]
  Blue as integer[]
endtype
function LoadExtraTreeData(iFile as string,iObject as integer,iTreeEffect as integer,iLeafEffect as integer)
   local tStr as string
   Vec1=CreateVector3() : Vec2=CreateVector3() : Vec3=CreateVector3()
   if GetFileExists(iFile)=1
      tTreeMeshCount=-1
      tFile=opentoread(iFile)
         tStr=ReadLine(tFile)
         tTreeMeshCount=val(GetStringToken2(tStr,"=",2)) : `"meshes="
         local dim tCull[tTreeMeshCount] as integer
         local dim tAlphaMask[tTreeMeshCount] as integer
         local dim tVertexColors[tTreeMeshCount] as VertexColorsData
         tStr=ReadLine(tFile) : `"{"
         for m=1 to tTreeMeshCount
             tStr=ReadLine(tFile)
             tCull[m]=val(GetStringToken2(tStr,"=",2)) : `"cull="
             tStr=ReadLine(tFile)
             tAlphaMask[m]=val(GetStringToken2(tStr,"=",2)) : `"alpha="
             tStr=ReadLine(tFile)
             tVertices=val(GetStringToken2(tStr,"=",2)) : `"colors="
             tVertexColors[m].Red.length=tVertices
             tVertexColors[m].Green.length=tVertices
             tVertexColors[m].Blue.length=tVertices
             tStr=ReadLine(tFile) : `"{"
             for v=0 to tVertices-1
                tStr=ReadLine(tFile)
                tVertexColors[m].Red[v]=val(GetStringToken2(tStr,",",1))
                tVertexColors[m].Green[v]=val(GetStringToken2(tStr,",",2))
                tVertexColors[m].Blue[v]=val(GetStringToken2(tStr,",",3))
             next v
             tStr=ReadLine(tFile) : `"}"
         next m
      closefile(tFile)
      if tTreeMeshCount=GetObjectNumMeshes(iObject)
         for m=1 to tTreeMeshCount
            tOldMemblock=CreateMemblockFromObjectMesh(iObject,m)
            tAddExtraData=1
            for v=20 to GetMemblockInt(tOldMemblock,16) step 4
               if GetMemblockString(tOldMemblock,v,5)="color" then tAddExtraData=0
               if GetMemblockString(tOldMemblock,v,7)="tangent" then tAddExtraData=0
            next v
            if tAddExtraData=1
               tOldMemblockSize=GetMemblockSize(tOldMemblock)
               tOldAttributes=GetMemblockInt(tOldMemblock,8)
               tOldVertexSize=GetMemblockInt(tOldMemblock,12)
               tOldVertexData=GetMemblockInt(tOldMemblock,16)
               tOldIndexData=GetMemblockInt(tOldMemblock,20)
               tNewVertexCount=GetMemblockInt(tOldMemblock,0)
               tNewIndexCount=GetMemblockInt(tOldMemblock,4)
               tNewAttributes=tOldAttributes+2
               tNewVertexSize=tOldVertexSize+16
               tNewVertexData=tOldVertexData+24
               tNewIndexData=tNewVertexData+(tNewVertexCount*tNewVertexSize)
               tNewMemblock=CreateMemblock(tNewIndexData+(tNewIndexCount*4))
               SetMemblockInt(tNewMemblock,0,tNewVertexCount)
               SetMemblockInt(tNewMemblock,4,tNewIndexCount)
               SetMemblockint(tNewMemblock,8,tNewAttributes)
               Setmemblockint(tNewMemblock,12,tNewVertexSize)
               SetMemblockInt(tNewMemblock,16,tNewVertexData)
               SetMemblockInt(tNewMemblock,20,tNewIndexData)
               tSize=tOldVertexData-24
               CopyMemblock(tOldMemblock,tNewMemblock,24,24,tSize)
               SetMemblockInt(tNewMemblock,tOldVertexData,0x08010401)
               SetMemblockString(tNewMemblock,tOldVertexData+4,"color")
               SetMemblockInt(tNewMemblock,tOldVertexData+12,0x08000300)
               SetMemblockString(tNewMemblock,tOldVertexData+16,"tangent")
               if tNewIndexCount>0
                  tSize=tNewIndexCount*4
                  CopyMemblock(tOldMemblock,tNewMemblock,tOldIndexData,tNewIndexData,tSize)
               endif
               local dim tVertexTangent[tNewVertexCount] as Vec3Float
               if tNewIndexCount=0 then tIndices=tNewVertexCount else tIndices=tNewIndexCount
               tPos=tOldIndexData
               for v=0 to tIndices-1 step 3
                  if tNewIndexCount>0
                     i1=GetMemblockInt(tOldMemblock,tPos):inc tPos,4
                     i2=GetMemblockInt(tOldMemblock,tPos):inc tPos,4
                     i3=GetMemblockInt(tOldMemblock,tPos):inc tPos,4   
                  else
                     i1=v+0 : i2=v+1 : i3=v+2
                  endif
                  Vector4Float[262].x=GetMeshMemblockVertexX(tOldMemblock,i2)-GetMeshMemblockVertexX(tOldMemblock,i1)
                  Vector4Float[263].x=GetMeshMemblockVertexX(tOldMemblock,i3)-GetMeshMemblockVertexX(tOldMemblock,i1)
                  Vector4Float[262].y=GetMeshMemblockVertexY(tOldMemblock,i2)-GetMeshMemblockVertexY(tOldMemblock,i1)
                  Vector4Float[263].y=GetMeshMemblockVertexY(tOldMemblock,i3)-GetMeshMemblockVertexY(tOldMemblock,i1)
                  Vector4Float[262].z=GetMeshMemblockVertexZ(tOldMemblock,i2)-GetMeshMemblockVertexZ(tOldMemblock,i1)
                  Vector4Float[263].z=GetMeshMemblockVertexZ(tOldMemblock,i3)-GetMeshMemblockVertexZ(tOldMemblock,i1)
                  Vector2Float[262].x=GetMeshMemblockVertexu(tOldMemblock,i2)-GetMeshMemblockVertexu(tOldMemblock,i1)
                  Vector2Float[263].x=GetMeshMemblockVertexu(tOldMemblock,i3)-GetMeshMemblockVertexu(tOldMemblock,i1)
                  Vector2Float[262].y=GetMeshMemblockVertexv(tOldMemblock,i2)-GetMeshMemblockVertexv(tOldMemblock,i1)
                  Vector2Float[263].y=GetMeshMemblockVertexv(tOldMemblock,i3)-GetMeshMemblockVertexv(tOldMemblock,i1)
                  SetVector3(Vec1,Vector4Float[262].x,Vector4Float[262].y,Vector4Float[262].z)
                  SetVector3(Vec2,Vector4Float[263].x,Vector4Float[263].y,Vector4Float[263].z)
                  GetVector3Cross(Vec3,Vec1,Vec2)
                  Vector4Float[261].w=GetVector3Length(Vec3)
                  SetVector3(Vec3,getVector3X(Vec3)/Vector4Float[261].w,getVector3Y(Vec3)/Vector4Float[261].w,getVector3Z(Vec3)/Vector4Float[261].w)
                  Vector4Float[261].w=1.0/(Vector2Float[262].x*Vector2Float[263].y-Vector2Float[263].x*Vector2Float[262].y)
                  Vector4Float[261].x=(Vector2Float[263].y*Vector4Float[262].x-Vector2Float[262].y*Vector4Float[263].x)*Vector4Float[261].w
                  Vector4Float[261].y=(Vector2Float[263].y*Vector4Float[262].y-Vector2Float[262].y*Vector4Float[263].y)*Vector4Float[261].w
                  Vector4Float[261].z=(Vector2Float[263].y*Vector4Float[262].z-Vector2Float[262].y*Vector4Float[263].z)*Vector4Float[261].w
                  SetVector3(Vec2,Vector4Float[261].x,Vector4Float[261].y,Vector4Float[261].z)
                  Vector4Float[261].w=GetVector3Dot(Vec3,Vec2)
                  Vector4Float[261].x=Vector4Float[261].x-(GetVector3X(Vec3)*Vector4Float[261].w)
                  Vector4Float[261].y=Vector4Float[261].y-(GetVector3Y(Vec3)*Vector4Float[261].w)
                  Vector4Float[261].z=Vector4Float[261].z-(GetVector3Z(Vec3)*Vector4Float[261].w)
                  tVertexTangent[i1].x=tVertexTangent[i1].x+Vector4Float[261].x
                  tVertexTangent[i1].y=tVertexTangent[i1].y+Vector4Float[261].y
                  tVertexTangent[i1].z=tVertexTangent[i1].z+Vector4Float[261].z
                  tVertexTangent[i2].x=tVertexTangent[i2].x+Vector4Float[261].x
                  tVertexTangent[i2].y=tVertexTangent[i2].y+Vector4Float[261].y
                  tVertexTangent[i2].z=tVertexTangent[i2].z+Vector4Float[261].z
                  tVertexTangent[i3].x=tVertexTangent[i3].x+Vector4Float[261].x
                  tVertexTangent[i3].y=tVertexTangent[i3].y+Vector4Float[261].y
                  tVertexTangent[i3].z=tVertexTangent[i3].z+Vector4Float[261].z
               next v
               tOldVPos=tOldVertexData
               tNewVPos=tNewVertexData
               for v=0 to tNewVertexCount-1
                  CopyMemblock(tOldMemblock,tNewMemblock,tOldVPos,tNewVPos,tOldVertexSize)
                  inc tOldVPos,tOldVertexSize
                  inc tNewVPos,tOldVertexSize
                  tVertexColor=MakeColor(tVertexColors[m].Red[v],tVertexColors[m].Green[v],tVertexColors[m].Blue[v])
                  SetMemblockInt(tNewMemblock,tNewVPos,tVertexColor)
                  SetVector3(Vec1,tVertexTangent[v].x,tVertexTangent[v].y,tVertexTangent[v].z)
                  L#=GetVector3Length(Vec1)
                  setMemblockFloat(tNewMemblock,tNewVPos+4,tVertexTangent[v].x/L#)
                  SetMemblockFloat(tNewMemblock,tNewVPos+8,tVertexTangent[v].y/L#)
                  SetMemblockFloat(tNewMemblock,tNewVPos+12,tVertexTangent[v].z/L#)
                  inc tNewVPos,16
               next v
               undim tVertexTangent[]
               SetObjectMeshFromMemblock(iObject,m,tNewMemblock)
               DeleteMemblock(tOldMemblock)
               DeleteMemblock(tNewMemblock)
               if tAlphaMask[m]=1 then SetObjectMeshEffect(iObject,m,iLeafEffect,0) else SetObjectMeshEffect(iObject,m,iTreeEffect,0)
               if tCull[m]=0 then SetObjectCullMode(iObject,0)
            endif
         next m
      endif
      undim tCull[]
      undim tAlphaMask[]
      undim tVertexColors[]
   endif
   DeleteVector3(Vec1) : DeleteVector3(Vec2) : DeleteVector3(Vec3)
endfunction

